/*
 * Decompiled with CFR 0.152.
 */
package specFX;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.mygdx.game.Game_;
import com.mygdx.game.Overlay;
import com.mygdx.game.Player;
import com.mygdx.game.Workspace;

public class HealthUI
extends Actor {
    Game_ game;
    Workspace workspace;
    Overlay overlay;
    private Player player;
    FreeTypeFontGenerator generator = new FreeTypeFontGenerator(Gdx.files.internal("fontUsing.ttf"));
    FreeTypeFontGenerator.FreeTypeFontParameter param;
    BitmapFont font;
    private ShapeRenderer shape;

    public HealthUI(Game_ g) {
        this.game = g;
        this.workspace = this.game.workspace;
        this.overlay = this.game.ui;
        this.player = this.workspace.player1;
        this.param = new FreeTypeFontGenerator.FreeTypeFontParameter();
        this.param.size = 36;
        this.font = this.generator.generateFont(this.param);
        this.font.setColor(Color.WHITE);
        this.shape = new ShapeRenderer();
        this.setX(20.0f);
        this.setY(640.0f);
    }

    public void act(float delta) {
        super.act(delta);
    }

    public void draw(Batch batch, float parentAlpha) {
        batch.end();
        this.shape.setProjectionMatrix(batch.getProjectionMatrix());
        Gdx.gl.glEnable(3042);
        this.shape.begin(ShapeRenderer.ShapeType.Filled);
        this.shape.setColor(Color.DARK_GRAY);
        this.shape.rect(this.getX(), this.getY() - 2.0f, 339.0f, 62.0f);
        this.shape.setColor(Color.FIREBRICK);
        this.shape.rect(this.getX() + 10.0f, this.getY() + 2.0f, 320.0f, 54.0f);
        this.shape.setColor(Color.BLUE);
        this.shape.rect(this.getX() + 10.0f, this.getY() + 2.0f, 320.0f * (this.workspace.player1.getHealth() / 100.0f), 54.0f);
        this.shape.end();
        batch.begin();
        this.font.setColor(Color.WHITE);
        this.font.draw(batch, (CharSequence)("Poll Lead " + Math.round(this.workspace.player1.getHealth()) + "/100"), this.getX() + 20.0f, this.getY() + 45.0f);
        this.font.setColor(Color.RED);
        if (this.game.RoundTimer.current != 0) {
            this.font.setColor(new Color(1.0f, 0.8235294f, 0.0f, 0.6f));
        }
        this.font.draw(batch, (CharSequence)("" + this.game.Round), 1180.0f, 690.0f);
        this.font.setColor(Color.ORANGE);
        this.font.draw(batch, (CharSequence)("Votes: " + this.game.points), 10.0f, 300.0f);
        this.font.setColor(Color.WHITE);
        if (this.player.nearest != null) {
            this.font.draw(batch, (CharSequence)this.player.nearest.getLabel(), 310.0f, 50.0f);
        }
        super.draw(batch, parentAlpha);
    }
}

