/*
 * Decompiled with CFR 0.152.
 */
package specFX;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;

public class Blood
extends Actor {
    private float[] VelXs;
    private float[] VelYs;
    private float[] VelSpds;
    private float DiperseRate;
    private float alpha = 1.0f;
    private float[] Sizes;
    private int time = 0;
    private float vrange = 12.0f;
    private int drange = 8;
    private final int srange = 10;
    private Color color = Color.RED;
    private ShapeRenderer shape;

    public Blood(float x, float y) {
        this(x, y, Color.RED, 16, 2.0f, 0.03f);
    }

    public Blood(float x, float y, Color c) {
        this(x, y, c, 16, 2.0f, 0.03f);
    }

    public Blood(float x, float y, int clots) {
        this(x, y, Color.RED, clots, 3.0f, 0.03f);
    }

    public Blood(float x, float y, Color c, int clots) {
        this(x, y, c, clots, 2.0f, 0.03f);
    }

    public Blood(float x, float y, Color c, int clots, float vel) {
        this(x, y, c, clots, vel, 0.03f);
    }

    public float getMagnitude(Vector2 v2) {
        float mag = (float)Math.sqrt(v2.x * v2.x + v2.y * v2.y);
        return mag;
    }

    public Vector2 getUnitVector(Vector2 v2) {
        float mag = this.getMagnitude(v2);
        return new Vector2(v2.x / mag, v2.y / mag);
    }

    public Blood(float x, float y, Color c, int clots, float f, float drate) {
        this.DiperseRate = drate;
        this.setX(x);
        this.setY(y);
        this.vrange = f;
        this.VelXs = new float[clots];
        this.VelYs = new float[this.VelXs.length];
        this.Sizes = new float[this.VelXs.length];
        this.VelSpds = new float[this.VelXs.length];
        int i = 0;
        while (i < this.VelXs.length) {
            Vector2 unitVec = this.getUnitVector(new Vector2((float)(MathUtils.random((int)this.drange) - this.drange / 2), (float)(MathUtils.random((int)this.drange) - this.drange / 2)));
            this.VelXs[i] = unitVec.x;
            this.VelYs[i] = unitVec.y;
            this.VelSpds[i] = MathUtils.random((float)(this.vrange / 2.0f)) + this.vrange / 2.0f;
            this.Sizes[i] = MathUtils.random((int)10) - 5;
            ++i;
        }
        this.shape = new ShapeRenderer();
        this.color = c;
    }

    public void draw(Batch batch, float parentAlpha) {
        batch.end();
        this.shape.setProjectionMatrix(batch.getProjectionMatrix());
        this.shape.begin(ShapeRenderer.ShapeType.Filled);
        this.shape.setColor(this.color.r, this.color.g, this.color.b, this.alpha);
        int i = 0;
        while (i < this.VelXs.length) {
            this.shape.rect(this.getX() + (float)this.time * this.VelXs[i] * this.VelSpds[i], this.getY() + (float)this.time * this.VelYs[i] * this.vrange, this.Sizes[i], this.Sizes[i]);
            this.VelSpds[i] = this.VelSpds[i] - 0.005f;
            ++i;
        }
        this.shape.end();
        batch.begin();
        super.draw(batch, parentAlpha);
    }

    public void act(float delta) {
        this.alpha -= this.DiperseRate;
        if ((double)this.alpha < 0.05) {
            this.remove();
            return;
        }
        ++this.time;
        super.act(delta);
    }
}

