/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.mygdx.game.Bullet;
import com.mygdx.game.Entity;
import com.mygdx.game.Workspace;
import specFX.Blood;

public class Weapon
extends Image {
    public TextureRegion top;
    public TextureRegion view;
    public float ROF;
    public int accuracy;
    public float damage;
    public int reload;
    public float weight;
    public String name;
    public int clipSize;
    public int currentClip;
    public int ammo;
    private int counter;
    public int rays;
    public Entity player;
    public Workspace workspace;
    private int relCounter;

    public Weapon(String name, float rof, int acc, float dmg, int rel, float weight, int clipsize, int rays, Entity player) {
        this.ROF = rof;
        this.accuracy = acc;
        this.damage = dmg;
        this.reload = rel;
        this.weight = weight;
        this.player = player;
        this.clipSize = clipsize;
        this.ammo = this.clipSize * 10;
        this.name = name;
        this.rays = rays;
        this.currentClip = this.clipSize;
        this.workspace = player.workspace;
        this.counter = 0;
        this.relCounter = 0;
        this.top = ((TextureAtlas)this.workspace.game.manager.get("GunAtlas.atlas")).findRegion("Top" + name);
        this.view = ((TextureAtlas)this.workspace.game.manager.get("GunAtlas.atlas")).findRegion("View" + name);
        this.setBounds(player.getWidth() / 2.0f - (float)(this.top.getRegionWidth() / 4), player.getHeight() - 20.0f, this.top.getRegionWidth() / 2, this.top.getRegionHeight() / 2);
    }

    public void draw(Batch batch, float parentAlpha) {
        batch.draw(this.top, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        super.draw(batch, parentAlpha);
    }

    public void act(float delta) {
        if (this.counter != 0) {
            ++this.counter;
            if ((float)this.counter >= this.ROF) {
                this.counter = 0;
            }
        }
        if (Gdx.input.isKeyPressed(46) && this.relCounter == 0) {
            ++this.relCounter;
        }
        if (this.relCounter != 0) {
            ++this.relCounter;
            if (this.relCounter == this.reload) {
                this.relCounter = 0;
                this.counter = 1;
                this.ammo -= this.clipSize - this.currentClip;
                this.currentClip = this.clipSize;
                if (this.ammo < 0) {
                    this.ammo = 0;
                    this.currentClip = 0;
                }
            }
        }
        super.act(delta);
    }

    public void Fire(Vector2 dir) {
        if (this.counter != 0 || this.ammo <= 0) {
            return;
        }
        if (this.currentClip != 0) {
            ++this.counter;
            --this.currentClip;
            int i = 0;
            while (i < this.rays) {
                Vector2 Direction = dir;
                int offset = MathUtils.random((int)this.accuracy) - this.accuracy / 2;
                Sound f = (Sound)this.workspace.game.manager.get("Fire.mp3");
                f.play(0.1f, 1.5f, 0.0f);
                Direction.setAngle(new Vector2(0.0f, 1.0f).angle(dir) + 90.0f + (float)offset);
                Vector2 xy = this.localToStageCoordinates(new Vector2(this.getWidth() / 3.0f + 3.0f, this.getHeight()));
                this.workspace.addActor((Actor)new Bullet(Direction.x, Direction.y, xy.x, xy.y, this.player, this.damage));
                this.workspace.addActor(new Blood(xy.x, xy.y, Color.YELLOW, 5, 3.0f));
                ++i;
            }
            return;
        }
        if (this.relCounter == 0) {
            ++this.relCounter;
        }
    }
}

