/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Touchpad;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.viewport.StretchViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.mygdx.game.Game_;
import com.mygdx.game.LoadScreen;
import com.mygdx.game.WeaponUI;
import specFX.Countdown;
import specFX.HealthUI;
import specFX.KillStreakUI;

public class Overlay
extends Stage {
    public Game_ game;
    public LoadScreen ls;
    private boolean loadedUI = false;
    public Touchpad touchpad;

    public Overlay(Game_ game) {
        super((Viewport)new StretchViewport(1280.0f, 720.0f));
        this.game = game;
        this.ls = new LoadScreen(game);
        this.addActor((Actor)this.ls);
    }

    public void act(float delta) {
        if (this.game.manager.getProgress() < 0.99f) {
            this.ls.show();
        } else {
            this.ls.hide();
            if (!this.loadedUI) {
                this.loadedUI = true;
                this.addActor(new HUD());
                this.addActor((Actor)new WeaponUI(this.game));
                this.addActor(new HealthUI(this.game));
                this.addActor((Actor)new KillStreakUI(this.game));
                this.addActor(new Countdown(this.game));
                Touchpad.TouchpadStyle style = new Touchpad.TouchpadStyle();
                style.background = new TextureRegionDrawable(new TextureRegion((Texture)this.game.manager.get("playerStick.png")));
                this.touchpad = new Touchpad(20.0f, style);
                this.touchpad.setBounds(0.0f, 0.0f, 200.0f, 200.0f);
                this.addActor((Actor)this.touchpad);
                this.game.workspace.player1.onScreenController = this.touchpad;
                Gdx.input.setInputProcessor((InputProcessor)this);
            }
        }
        super.act(delta);
    }

    public void End() {
        if (this.ls.ended) {
            return;
        }
        this.game.workspace.clear();
        this.ls.remove();
        this.ls = new LoadScreen(this.game);
        this.addActor((Actor)this.ls);
        this.ls.end();
    }

    private class HUD
    extends Actor {
        private HUD() {
        }

        public void draw(Batch batch, float parentAlpha) {
            super.draw(batch, parentAlpha);
            batch.draw((Texture)Overlay.this.game.manager.get("HUD.png"), 0.0f, 0.0f);
        }
    }
}

