/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.mygdx.game.Effector;
import com.mygdx.game.Game_;
import com.mygdx.game.Player;
import specFX.Blood;

public class GateEffector
extends Actor
implements Effector {
    private float price;
    private String text;
    private Game_ game;
    private Texture tex;

    public GateEffector(float cost, float x, float y, Game_ g) {
        this.price = cost;
        this.text = "Press action key to clear the barrier, " + this.price + "pts";
        this.setX(x);
        this.setY(y);
        this.game = g;
        this.tex = (Texture)this.game.manager.get("rubble.png");
    }

    @Override
    public String getLabel() {
        return this.text;
    }

    @Override
    public float getPrice() {
        return this.price;
    }

    @Override
    public void Action(Player player) {
        if ((float)this.game.points > this.price) {
            this.game.points = (int)((float)this.game.points - this.price);
            this.game.workspace.addActor(new Blood(this.getX(), this.getY(), Color.GREEN, 20));
            this.game.workspace.worldText.addString("-" + this.price, this.getX(), this.getY());
            this.game.Effectors.removeValue((Object)this, true);
            this.remove();
        }
    }

    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        batch.draw(this.tex, this.getX() - (float)(this.tex.getWidth() / 2), this.getY() - (float)this.tex.getHeight());
    }

    public void act(float delta) {
        super.act(delta);
        Player player = this.game.workspace.player1;
        float mag = this.getPlayerOffset(player);
        if (mag < 50.0f) {
            player.setX(player.oldX);
            player.setY(player.oldY);
        }
        if ((mag = this.getPlayerOffset(player)) < 50.0f) {
            Vector2 offset = player.getOffset(this.getX(), this.getY());
            player.setX(player.getX() - offset.x);
            player.setY(player.getY() - offset.y);
        }
    }

    public float getPlayerOffset(Player player) {
        Vector2 offset = player.getOffset(this.getX(), this.getY());
        float mag = player.getMagnitude(offset);
        return mag;
    }
}

