/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.viewport.StretchViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.mygdx.game.Banner;
import com.mygdx.game.Counter;
import com.mygdx.game.Effector;
import com.mygdx.game.MyGdxGame;
import com.mygdx.game.Overlay;
import com.mygdx.game.Spawner;
import com.mygdx.game.Workspace;

public class Game_
implements Screen {
    public Overlay ui;
    public Workspace workspace;
    public MyGdxGame game;
    public AssetManager manager;
    private int loaded = 0;
    public boolean draw = true;
    public int ZombiesAlive;
    public int ZombiesToSpawn;
    public int ZombieCap = 20;
    public int Round = 0;
    private int frames = 0;
    public Stage ADs;
    private Array<Spawner> toSpawn = new Array();
    private long time;
    public Counter RoundTimer;
    public boolean started = false;
    public int streakCounter = 0;
    public float radius = 0.0f;
    public int points;
    public Counter SpawnTimer;
    public int killStreak = 0;
    public Array<Spawner> spawners = new Array<Spawner>(){

        public void add(Spawner value) {
            Game_.this.workspace.addActor(value);
            super.add((Object)value);
        }
    };
    public Array<Effector> Effectors = new Array<Effector>(){

        public void add(Effector value) {
            Game_.this.workspace.addActor((Actor)value);
            super.add((Object)value);
        }
    };
    private int spawnTime;

    Game_(MyGdxGame game) {
        this.game = game;
        this.ui = new Overlay(this);
        this.ZombiesAlive = 1;
        this.workspace = new Workspace(this);
        this.ADs = new Stage((Viewport)new StretchViewport(1280.0f, 720.0f));
        this.manager = game.manager;
        this.points = 0;
        this.radius = (float)(Math.sqrt(Math.pow(1280.0, 2.0) + Math.pow(720.0, 2.0)) / 2.0);
        if (this.manager == null) {
            this.manager = game.manager = new AssetManager();
            this.manager.load("player.png", Texture.class);
            this.manager.load("loading.png", Texture.class);
            this.manager.load("maps/DataMap1.png", Pixmap.class);
            this.manager.load("maps/TextureMap1.png", Texture.class);
            this.manager.load("maps/DataMap2.png", Pixmap.class);
            this.manager.load("maps/TextureMap2.png", Texture.class);
            this.manager.load("GunAtlas.atlas", TextureAtlas.class);
            this.manager.load("Tank.png", Texture.class);
            this.manager.load("playerStick.png", Texture.class);
            this.manager.load("HUD.png", Texture.class);
            this.manager.load("Fire.mp3", Sound.class);
            this.manager.load("Banner.jpg", Texture.class);
            this.manager.load("rubble.png", Texture.class);
            this.manager.load("Kamikaze.png", Texture.class);
            this.manager.load("zombie.png", Texture.class);
            this.manager.load("button.png", Texture.class);
            this.manager.load("stain1.png", Texture.class);
            this.manager.load("stain2.png", Texture.class);
            this.manager.load("stain3.png", Texture.class);
            this.manager.load("Three.png", Texture.class);
            this.manager.load("Two.png", Texture.class);
            this.manager.load("One.png", Texture.class);
            this.manager.load("Zurvive.png", Texture.class);
            this.manager.load("Controls.png", Texture.class);
            this.manager.load("GunBG.png", Texture.class);
            this.manager.load("Killstreak.png", Texture.class);
            this.manager.load("DeathScreen.png", Texture.class);
        }
        this.spawnTime = 90;
        this.time = System.currentTimeMillis();
        this.RoundTimer = new Counter(250, false);
        this.SpawnTimer = new Counter(500, true);
        this.nextRound();
    }

    public void nextRound() {
        ++this.Round;
        this.ZombiesAlive = 0;
        this.ZombiesToSpawn = Math.round((float)(this.Round * this.ZombieCap) * 0.15f) + 3;
        this.RoundTimer.current = 0;
        this.RoundTimer.finished = false;
        if (this.spawnTime > 45) {
            this.spawnTime -= 11;
        }
    }

    public void show() {
    }

    public void render(float delta) {
        Spawner z;
        Gdx.gl.glClear(16384);
        if (this.ui != null && this.ui.ls.ended) {
            Gdx.gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        }
        this.manager.update();
        if (this.manager.getProgress() > 0.98f) {
            if (this.loaded == 0) {
                ++this.loaded;
                this.workspace.assetLoaded();
                this.ADs.addActor((Actor)new Banner(this));
            }
            Gdx.gl.glViewport(0, 0, Gdx.graphics.getWidth(), (int)((float)Gdx.graphics.getHeight() * 0.85f));
            this.workspace.draw();
            this.workspace.act();
        }
        this.ui.act();
        this.ui.draw();
        Gdx.gl.glViewport(0, 0, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.ADs.draw();
        this.ADs.act();
        ++this.frames;
        if (System.currentTimeMillis() - this.time >= 1000L) {
            this.time += 1000L;
            this.frames = 0;
        }
        if (this.streakCounter > 0) {
            --this.streakCounter;
            if (this.streakCounter <= 0) {
                this.killStreak = 0;
            }
        }
        this.SpawnTimer.update();
        if (this.SpawnTimer.current % this.spawnTime == 0 && this.toSpawn.size >= 1 && (z = (Spawner)((Object)this.toSpawn.first())) != null) {
            Vector2 v2off = new Vector2(z.getX() - this.workspace.player1.getX(), z.getY() - this.workspace.player1.getY());
            z.offset = (float)Math.sqrt(v2off.x * v2off.x + v2off.y * v2off.y);
            if (!(z.offset < 350.0f)) {
                z.Spawn();
                this.toSpawn.removeRange(0, 0);
            }
        }
        if (this.ZombiesToSpawn >= 1 && this.spawners.size > 1 && this.started) {
            int i = 0;
            while (i < this.spawners.size) {
                if (this.ZombiesToSpawn > 0) {
                    Spawner spawner = (Spawner)((Object)this.spawners.get(i));
                    Vector2 v2off = new Vector2(spawner.getX() - this.workspace.player1.getX(), spawner.getY() - this.workspace.player1.getY());
                    spawner.offset = (float)Math.sqrt(v2off.x * v2off.x + v2off.y * v2off.y);
                    if (spawner.offset > this.radius * 0.7f || spawner.offset < 350.0f) {
                        spawner.canSpawn = false;
                    } else if (spawner.canSpawn) {
                        int spawnAmount = MathUtils.random((int)1, (int)2);
                        spawnAmount = spawnAmount > this.ZombiesToSpawn ? this.ZombiesToSpawn : spawnAmount;
                        int Amountspawned = 0;
                        while (Amountspawned < spawnAmount) {
                            this.toSpawn.add((Object)spawner);
                            ++this.ZombiesAlive;
                            --this.ZombiesToSpawn;
                            ++Amountspawned;
                        }
                    }
                    ++i;
                    continue;
                }
                break;
            }
        } else if (this.ZombiesAlive == 0 && this.ZombiesToSpawn == 0) {
            this.RoundTimer.update();
            if (this.RoundTimer.finished) {
                this.nextRound();
            }
        }
    }

    public void resize(int width, int height) {
        this.ui.getViewport().update(width, height, true);
        this.workspace.getViewport().update(width, height);
    }

    public void pause() {
    }

    public void resume() {
    }

    public void hide() {
    }

    public void dispose() {
        this.workspace.dispose();
        this.ui.dispose();
        this.manager.dispose();
    }
}

