/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.MoveByAction;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.mygdx.game.Splash;
import specFX.Blood;

public class Button
extends Image {
    Stage stage;
    ShapeRenderer shape;
    String text;
    FreeTypeFontGenerator generator = new FreeTypeFontGenerator(Gdx.files.internal("fontUsing.ttf"));
    FreeTypeFontGenerator.FreeTypeFontParameter param;
    BitmapFont font;
    Rectangle bounds;
    Color color = Color.WHITE;
    Splash splash;
    boolean Clicked = false;
    boolean mouseEntered = false;
    private Texture tex;

    Button(int y, Stage stage, String txt, Splash s) {
        this.splash = s;
        this.param = new FreeTypeFontGenerator.FreeTypeFontParameter();
        this.param.size = 55;
        this.shape = new ShapeRenderer();
        this.font = this.generator.generateFont(this.param);
        this.text = txt;
        this.stage = stage;
        this.setBounds(stage.getWidth() * 0.3f, y, stage.getWidth() / 5.0f * 2.0f, 80.0f);
        this.bounds = new Rectangle(stage.getWidth() * 0.3f, (float)y, stage.getWidth() / 5.0f * 2.0f, 80.0f);
        this.setTouchable(Touchable.enabled);
        this.tex = new Texture(Gdx.files.internal("button.png"));
    }

    public void act(float delta) {
        super.act(delta);
    }

    private void mouseEnter() {
        MoveByAction mba = new MoveByAction();
        mba.setAmountX(80.0f);
        mba.setDuration(0.3f);
        this.addAction((Action)mba);
        this.color = Color.YELLOW;
        Vector2 mpos = this.stage.screenToStageCoordinates(new Vector2((float)Gdx.input.getX(), (float)Gdx.input.getY()));
        this.stage.addActor((Actor)new Blood(mpos.x, mpos.y));
    }

    private void mouseLeave() {
        MoveByAction mba = new MoveByAction();
        mba.setAmountX(-80.0f);
        mba.setDuration(0.2f);
        this.addAction((Action)mba);
        this.color = Color.WHITE;
    }

    public void draw(Batch batch, float parentAlpha) {
        batch.end();
        Vector2 mpos = this.stage.screenToStageCoordinates(new Vector2((float)Gdx.input.getX(), (float)Gdx.input.getY()));
        if (this.bounds.contains(mpos)) {
            if (!this.mouseEntered) {
                this.mouseEntered = true;
                this.mouseEnter();
            }
            if (Gdx.input.isButtonPressed(0)) {
                this.Clicked = true;
                this.mouseLeave();
                this.splash.Play();
            }
        } else if (this.mouseEntered) {
            this.mouseEntered = false;
            this.mouseLeave();
        }
        this.shape.setProjectionMatrix(batch.getProjectionMatrix());
        this.shape.setProjectionMatrix(batch.getProjectionMatrix());
        Gdx.gl.glEnable(3042);
        this.shape.begin(ShapeRenderer.ShapeType.Filled);
        this.shape.end();
        Gdx.gl.glDisable(3042);
        batch.begin();
        batch.draw(this.tex, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.font.setColor(this.color);
        this.font.draw(batch, (CharSequence)this.text, this.getX() + this.getWidth() / 3.0f * 1.2f, this.getY() + 60.0f);
    }
}

