/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.actions.RotateToAction;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.mygdx.game.Entity;
import com.mygdx.game.Workspace;
import specFX.Blood;

public class Bullet
extends Image {
    protected final Vector2 movement;
    protected float speed = 35.0f;
    protected Entity origin;
    protected int timeAlive = 0;
    protected ShapeRenderer shape;
    private float alpha = 1.0f;
    private int wait = 0;
    private Vector2 startV2;
    private float friction = 0.2f;
    private Workspace workspace;
    private Pixmap map;
    private float damage;

    public Bullet(float v2x, float v2y, float x, float y, Entity sentBy, float dmg) {
        this.movement = new Vector2(v2x, v2y);
        this.origin = sentBy;
        this.damage = dmg;
        this.setX(x);
        this.setY(y);
        this.startV2 = new Vector2(this.getX(), this.getY());
        this.shape = new ShapeRenderer();
        this.setBounds(x, y, 3.0f, 12.0f);
        float angle = new Vector2(0.0f, 1.0f).angle(this.movement);
        RotateToAction rot = new RotateToAction();
        rot.setRotation(angle);
        this.addAction((Action)rot);
        this.workspace = sentBy.workspace;
        this.map = this.workspace.currentMap.dataMap;
    }

    public void draw(Batch batch, float parentAlpha) {
        if (!this.workspace.game.draw) {
            return;
        }
        if (this.wait < 1) {
            ++this.wait;
            return;
        }
        batch.end();
        this.shape.setProjectionMatrix(batch.getProjectionMatrix());
        Gdx.gl.glEnable(3042);
        this.shape.begin(ShapeRenderer.ShapeType.Filled);
        this.shape.setColor(Color.YELLOW.r, Color.YELLOW.g, Color.YELLOW.b, 1.0f);
        this.shape.rect(this.getX(), this.getY(), this.getWidth() / 2.0f, this.getHeight() / 2.0f, this.getWidth(), this.getHeight(), 1.0f, 1.0f, this.getRotation());
        this.shape.setColor(Color.ORANGE.r, Color.ORANGE.g, Color.ORANGE.b, 1.0f);
        this.shape.rect(this.getX(), this.getY(), this.getWidth() / 2.0f, this.getHeight() / 2.0f, this.getWidth(), this.getHeight() / 5.0f * 3.0f, 1.0f, 1.0f, this.getRotation());
        this.shape.end();
        Gdx.gl.glDisable(3042);
        batch.begin();
        super.draw(batch, parentAlpha);
    }

    public void act(float delta) {
        Rectangle bounds = new Rectangle(this.getX(), this.getY(), 40.0f, 40.0f);
        int i = 0;
        while (i < this.workspace.getActors().size) {
            Actor a = (Actor)this.workspace.getActors().get(i);
            if (a instanceof Entity) {
                Entity ent = (Entity)a;
                ent.calculateBounds();
                if (!((Object)((Object)ent)).equals((Object)this.origin) && ent.getBound().contains(bounds)) {
                    this.workspace.addActor(new Blood(this.getX(), this.getY()));
                    ent.setPosition(ent.getX() + 10.0f * this.movement.x, ent.getY() + 10.0f * this.movement.y);
                    this.Hit(ent);
                    this.remove();
                }
            }
            ++i;
        }
        int pixel = this.map.getPixel((int)this.getX(), this.map.getHeight() - (int)this.getY());
        Color color = new Color(pixel);
        float r1 = color.r;
        float g1 = color.g;
        float b1 = color.b;
        if (r1 == 0.78431374f && g1 == 0.39215687f & b1 == 0.78431374f) {
            this.speed = 0.0f;
        }
        this.setX(this.getX() + this.movement.x * this.speed);
        this.setY(this.getY() + this.movement.y * this.speed);
        ++this.timeAlive;
        if (this.timeAlive > 60) {
            this.remove();
        }
        float angle = new Vector2(0.0f, 1.0f).angle(this.movement);
        RotateToAction r = new RotateToAction();
        r.setRotation(angle);
        r.setDuration(0.0f);
        this.addAction((Action)r);
        this.alpha -= 0.023f;
        if (this.alpha < 0.1f) {
            this.alpha = 0.0f;
        }
        this.speed -= this.friction;
        super.act(delta);
    }

    public Vector2 getOffset(float x, float y) {
        return new Vector2(x - (this.getX() + this.getWidth() / 2.0f), y - (this.getY() + this.getHeight() / 2.0f));
    }

    public Vector2 getOffset(Vector2 v2) {
        return this.getOffset(v2.x, v2.y);
    }

    public float getMagnitude(Vector2 v2) {
        float mag = (float)Math.sqrt(v2.x * v2.x + v2.y * v2.y);
        return mag;
    }

    public Vector2 getUnitVector(Vector2 v2) {
        float mag = this.getMagnitude(v2);
        return new Vector2(v2.x / mag, v2.y / mag);
    }

    public void Hit(Entity hit) {
        hit.setHealth(hit.getHealth() - this.damage);
        this.workspace.game.points = (int)((float)this.workspace.game.points + this.damage / 5.0f * (1.0f + (float)this.workspace.game.killStreak / 4.0f));
        this.workspace.worldText.addString("+" + Math.round(this.damage / 5.0f * (1.0f + (float)this.workspace.game.killStreak / 4.0f)), this.getX(), this.getY());
        this.workspace.blood.addStain(hit.getX(), hit.getY());
    }
}

