/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.actions.RotateToAction;
import com.mygdx.game.Counter;
import com.mygdx.game.Entity;
import com.mygdx.game.ObjectId;
import com.mygdx.game.Workspace;

public abstract class Bot
extends Entity {
    private ObjectId[] target;
    protected Texture tex;
    private int attack = 0;
    public Counter timeOut;
    protected float damage;
    private float proximity = 0.0f;
    private float currentAngle;
    private ShapeRenderer shape;
    private float rotSpeed;
    protected Entity nearest;

    protected Bot(float x, float y, float w, float h, float health, ObjectId id, Workspace ws, ObjectId[] t, float speed, float dmg, float rotspd) {
        super(x, y, w, h, health, id, ws);
        this.setWidth(w);
        this.setHeight(h);
        this.target = t;
        this.speed = speed;
        this.shape = new ShapeRenderer();
        this.tex = (Texture)ws.game.manager.get("zombie.png");
        this.damage = dmg;
        this.timeOut = new Counter(1000, false);
        this.currentAngle = 0.0f;
        if (this.getWidth() > 85.0f) {
            this.damage = 2.5f * dmg;
        }
        this.rotSpeed = rotspd;
    }

    @Override
    public void act(float delta) {
        if (this.timeOut.finished) {
            ++this.workspace.game.ZombiesToSpawn;
            --this.workspace.game.ZombiesAlive;
            this.remove();
        }
        this.timeOut.update();
        this.nearest = this.workspace.player1;
        this.proximity = this.getMagnitude(this.getOffset(new Vector2(this.nearest.getX(), this.nearest.getY())));
        if (this.proximity > this.workspace.game.radius) {
            return;
        }
        Vector2 diff = this.getOffset(this.nearest.getX() + this.nearest.getWidth() / 2.0f, this.nearest.getY() + this.nearest.getHeight() / 2.0f);
        this.facing = this.getUnitVector(diff);
        this.facing.x *= this.speed;
        this.facing.y *= this.speed;
        if (this.proximity > 45.0f && this.proximity < this.workspace.game.radius) {
            this.rotate();
            this.setX(this.getX() + this.facing.x);
            this.setY(this.getY() + this.facing.y);
            this.timeOut.current = 0;
        }
        if (this.proximity < this.getWidth() & this.attack == 0) {
            this.Attack();
            ++this.attack;
        } else if (this.attack != 0) {
            ++this.attack;
            this.attack = this.attack > 40 ? 0 : this.attack;
        }
        this.FitBounds();
        if (this.health <= 0.0f) {
            this.alive = false;
            --this.workspace.game.ZombiesAlive;
            this.workspace.game.streakCounter = 230;
            ++this.workspace.game.killStreak;
            this.remove();
        }
        super.act(delta);
    }

    public void draw(Batch batch, float parentAlpha) {
        if (!this.workspace.game.draw) {
            return;
        }
        if (this.proximity >= this.workspace.game.radius) {
            return;
        }
        if (!(this.getWidth() > 85.0f) && this.getWidth() == 50.4f) {
            batch.setColor(0.5f, 0.65f, 0.5f, 1.0f);
        }
        batch.draw(this.tex, this.getX(), this.getY(), this.getWidth() / 2.0f, this.getHeight() / 2.0f, this.getWidth(), this.getHeight(), 0.7f, 0.7f, this.getRotation(), 0, 0, this.tex.getWidth(), this.tex.getHeight(), false, false);
        batch.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        batch.end();
        this.shape.setProjectionMatrix(batch.getProjectionMatrix());
        this.shape.setTransformMatrix(batch.getTransformMatrix());
        this.shape.begin(ShapeRenderer.ShapeType.Filled);
        this.shape.setColor(Color.BLUE);
        float i = 0.0f;
        while (i < 3.0f) {
            i += 0.1f;
        }
        this.shape.end();
        batch.begin();
        super.draw(batch, parentAlpha);
    }

    public void rotate() {
        float angle = new Vector2(0.0f, 1.0f).angle(this.facing);
        float diff = angle - this.currentAngle;
        this.currentAngle = angle - diff * this.rotSpeed;
        if (diff > 180.0f) {
            this.currentAngle = 180.0f;
        } else if (diff < -180.0f) {
            this.currentAngle = -180.0f;
        }
        RotateToAction rot = new RotateToAction();
        rot.setRotation(this.currentAngle);
        this.addAction((Action)rot);
        this.facing = new Vector2(0.0f, 1.0f).setAngle(this.currentAngle + 90.0f);
        this.facing.x *= this.speed;
        this.facing.y *= this.speed;
    }

    public abstract void Death();

    public abstract void Attack();
}

